/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.api.util.IGrowingPlant;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeBranch;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeTrunk;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockFruitTreeLeaves
extends BlockLeaves
implements IGrowingPlant {
    public static final PropertyEnum<EnumLeafState> LEAF_STATE = PropertyEnum.func_177709_a((String)"state", EnumLeafState.class);
    public static final PropertyBool HARVESTABLE = PropertyBool.func_177716_a((String)"harvestable");
    private static final Map<IFruitTree, BlockFruitTreeLeaves> MAP = new HashMap<IFruitTree, BlockFruitTreeLeaves>();
    private final IFruitTree tree;

    public static BlockFruitTreeLeaves get(IFruitTree tree) {
        return MAP.get(tree);
    }

    public BlockFruitTreeLeaves(IFruitTree tree) {
        this.tree = tree;
        if (MAP.put(tree, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a(LEAF_STATE, (Comparable)((Object)EnumLeafState.NORMAL)).func_177226_a((IProperty)HARVESTABLE, (Comparable)Boolean.valueOf(false)));
        this.field_185686_c = true;
        OreDictionaryHelper.register((Block)this, "tree", "leaves");
        OreDictionaryHelper.register((Block)this, "tree", "leaves", tree.getName());
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
        this.func_149675_a(true);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HARVESTABLE, (Comparable)Boolean.valueOf(meta > 3)).func_177226_a(LEAF_STATE, (Comparable)((Object)EnumLeafState.valueOf(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumLeafState)((Object)state.func_177229_b(LEAF_STATE))).ordinal() + ((Boolean)state.func_177229_b((IProperty)HARVESTABLE) != false ? 4 : 0);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)HARVESTABLE)).booleanValue() && this.tree.isHarvestMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear())) {
                long hours;
                TETickCounter te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class);
                if (te != null && (double)(hours = te.getTicksSinceUpdate() / 1000L) > (double)this.tree.getGrowthTime() * ConfigTFC.General.FOOD.fruitTreeGrowthTimeModifier) {
                    world.func_175656_a(pos, state.func_177226_a(LEAF_STATE, (Comparable)((Object)EnumLeafState.FRUIT)));
                    te.resetCounter();
                }
            } else if (this.tree.isFlowerMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear())) {
                if (state.func_177229_b(LEAF_STATE) != EnumLeafState.FLOWERING) {
                    world.func_175656_a(pos, state.func_177226_a(LEAF_STATE, (Comparable)((Object)EnumLeafState.FLOWERING)));
                }
            } else if (state.func_177229_b(LEAF_STATE) != EnumLeafState.NORMAL) {
                world.func_175656_a(pos, state.func_177226_a(LEAF_STATE, (Comparable)((Object)EnumLeafState.NORMAL)));
            }
            this.doLeafDecay(world, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, @Nullable Block blockIn, @Nullable BlockPos fromPos) {
        this.doLeafDecay(world, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TETickCounter tile = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (tile != null) {
            tile.resetCounter();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177229_b(LEAF_STATE) == EnumLeafState.FRUIT) {
            if (!worldIn.field_72995_K) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)this.tree.getFoodDrop());
                worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a(LEAF_STATE, (Comparable)((Object)EnumLeafState.NORMAL)));
                TETickCounter te = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
                if (te != null) {
                    te.resetCounter();
                }
            }
            return true;
        }
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer) || !((EntityPlayer)entityIn).func_184812_l_()) {
            entityIn.func_180430_e(entityIn.field_70143_R - 6.0f, 1.0f);
            entityIn.field_70143_R = 0.0f;
            entityIn.field_70159_w *= ConfigTFC.General.MISC.leafMovementModifier;
            if (entityIn.field_70181_x < 0.0) {
                entityIn.field_70181_x *= ConfigTFC.General.MISC.leafMovementModifier;
            }
            entityIn.field_70179_y *= ConfigTFC.General.MISC.leafMovementModifier;
        }
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176237_a, LEAF_STATE, HARVESTABLE});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TETickCounter();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.doLeafDecay(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        this.field_185686_c = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        return super.func_180664_k();
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        this.field_185686_c = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        return true;
    }

    @Nonnull
    public IFruitTree getTree() {
        return this.tree;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack((Block)this));
    }

    private void doLeafDecay(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        HashSet<Object> paths = new HashSet<Object>();
        HashSet<BlockPos> evaluated = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos(pos);
        paths.add(pos);
        for (int i = 0; i < 2; ++i) {
            ArrayList<BlockPos> pathsToAdd = new ArrayList<BlockPos>();
            for (BlockPos blockPos : paths) {
                for (EnumFacing face : EnumFacing.values()) {
                    pos1.func_189533_g((Vec3i)blockPos).func_189536_c(face);
                    if (evaluated.contains(pos1) || !world.func_175667_e((BlockPos)pos1)) continue;
                    IBlockState state1 = world.func_180495_p((BlockPos)pos1);
                    if (state1.func_177230_c() == BlockFruitTreeTrunk.get(this.tree) || state1.func_177230_c() == BlockFruitTreeBranch.get(this.tree)) {
                        return;
                    }
                    if (state1.func_177230_c() != this) continue;
                    pathsToAdd.add(pos1.func_185334_h());
                }
                evaluated.add(blockPos);
            }
            paths.addAll(pathsToAdd);
            paths.removeAll(evaluated);
        }
        world.func_175698_g(pos);
    }

    @Override
    public IGrowingPlant.GrowthStatus getGrowingStatus(IBlockState state, World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177229_b(LEAF_STATE) == EnumLeafState.FRUIT) {
            return IGrowingPlant.GrowthStatus.FULLY_GROWN;
        }
        if (!((Boolean)state.func_177229_b((IProperty)HARVESTABLE)).booleanValue() && this.tree.isHarvestMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear())) {
            return IGrowingPlant.GrowthStatus.GROWING;
        }
        return IGrowingPlant.GrowthStatus.NOT_GROWING;
    }

    public static enum EnumLeafState implements IStringSerializable
    {
        NORMAL,
        FLOWERING,
        FRUIT;

        private static final EnumLeafState[] VALUES;

        @Nonnull
        public static EnumLeafState valueOf(int index) {
            return index < 0 || index > VALUES.length ? NORMAL : VALUES[index];
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = EnumLeafState.values();
        }
    }
}

